<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Price extends Model 
{

    protected $table = 'prices';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('property_id', 'type', 'price', 'mid_week', 'end_week', 'cleaning_fees', 'service_visitor_fees', 'our_service_fees', 'deposit_fees', 'times');

    public function property()
    {
        return $this->belongsTo('App\Models\Property');
    }

}